module Color
  # Standard Web and X11 Colors
  ALICEBLUE = { r: 240, g: 248, b: 255 }.freeze
  ANTIQUEWHITE = { r: 250, g: 235, b: 215 }.freeze
  AQUA = { r: 0, g: 255, b: 255 }.freeze
  AQUAMARINE = { r: 127, g: 255, b: 212 }.freeze
  AZURE = { r: 240, g: 255, b: 255 }.freeze
  BEIGE = { r: 245, g: 245, b: 220 }.freeze
  BISQUE = { r: 255, g: 228, b: 196 }.freeze
  BLACK = { r: 0, g: 0, b: 0 }.freeze
  BLANCHEDALMOND = { r: 255, g: 235, b: 205 }.freeze
  BLUE = { r: 0, g: 0, b: 255 }.freeze
  BLUEVIOLET = { r: 138, g: 43, b: 226 }.freeze
  BROWN = { r: 165, g: 42, b: 42 }.freeze
  BURLYWOOD = { r: 222, g: 184, b: 135 }.freeze
  CADETBLUE = { r: 95, g: 158, b: 160 }.freeze
  CHARTREUSE = { r: 127, g: 255, b: 0 }.freeze
  CHOCOLATE = { r: 210, g: 105, b: 30 }.freeze
  CORAL = { r: 255, g: 127, b: 80 }.freeze
  CORNFLOWER = { r: 100, g: 149, b: 237 }.freeze
  CORNFLOWERBLUE = { r: 100, g: 149, b: 237 }.freeze
  CORNSILK = { r: 255, g: 248, b: 220 }.freeze
  CRIMSON = { r: 220, g: 20, b: 60 }.freeze
  CYAN = { r: 0, g: 255, b: 255 }.freeze
  DARKBLUE = { r: 0, g: 0, b: 139 }.freeze
  DARKCYAN = { r: 0, g: 139, b: 139 }.freeze
  DARKGOLDENROD = { r: 184, g: 134, b: 11 }.freeze
  DARKGRAY = { r: 169, g: 169, b: 169 }.freeze
  DARKGREEN = { r: 0, g: 100, b: 0 }.freeze
  DARKGREY = { r: 169, g: 169, b: 169 }.freeze
  DARKKHAKI = { r: 189, g: 183, b: 107 }.freeze
  DARKMAGENTA = { r: 139, g: 0, b: 139 }.freeze
  DARKOLIVEGREEN = { r: 85, g: 107, b: 47 }.freeze
  DARKORANGE = { r: 255, g: 140, b: 0 }.freeze
  DARKORCHID = { r: 153, g: 50, b: 204 }.freeze
  DARKRED = { r: 139, g: 0, b: 0 }.freeze
  DARKSALMON = { r: 233, g: 150, b: 122 }.freeze
  DARKSEAGREEN = { r: 143, g: 188, b: 143 }.freeze
  DARKSLATEBLUE = { r: 72, g: 61, b: 139 }.freeze
  DARKSLATEGRAY = { r: 47, g: 79, b: 79 }.freeze
  DARKSLATEGREY = { r: 47, g: 79, b: 79 }.freeze
  DARKTURQUOISE = { r: 0, g: 206, b: 209 }.freeze
  DARKVIOLET = { r: 148, g: 0, b: 211 }.freeze
  DEEPPINK =  { r: 255, g: 20, b: 147 }.freeze
  DEEPSKYBLUE = { r: 0, g: 191, b: 255 }.freeze
  DIMGRAY = { r: 105, g: 105, b: 105 }.freeze
  DIMGREY = { r: 105, g: 105, b: 105 }.freeze
  DODGERBLUE = { r: 30, g: 144, b: 255 }.freeze
  FIREBRICK = { r: 178, g: 34, b: 34 }.freeze
  FLORALWHITE = { r: 255, g: 250, b: 240 }.freeze
  FORESTGREEN = { r: 34, g: 139, b: 34 }.freeze
  FUCHSIA = { r: 255, g: 0, b: 255 }.freeze
  GAINSBORO = { r: 220, g: 220, b: 220 }.freeze
  GHOSTWHITE = { r: 248, g: 248, b: 255 }.freeze
  GOLD = { r: 255, g: 215, b: 0 }.freeze
  GOLDENROD = { r: 218, g: 165, b: 32 }.freeze
  GRAY = { r: 128, g: 128, b: 128 }.freeze
  GREEN = { r: 0, g: 128, b: 0 }.freeze
  GREENYELLOW = { r: 173, g: 255, b: 47 }.freeze
  GREY = { r: 128, g: 128, b: 128 }.freeze
  HONEYDEW = { r: 240, g: 255, b: 240 }.freeze
  HOTPINK = { r: 255, g: 105, b: 180 }.freeze
  INDIANRED = {r: 205, g:92, b: 92 }.freeze
  INDIGO = { r: 75, g: 0, b: 130 }.freeze
  IVORY = { r: 255, g: 255, b: 240 }.freeze
  KHAKI = { r: 240, g: 230, b: 140 }.freeze
  LASERLEMOON = { r: 255, g: 255, b: 102 }.freeze
  LAVENDER = { r: 230, g: 230, b: 250 }.freeze
  LAVENDERBLUSH = { r: 255, g: 240, b: 245 }.freeze
  LAWNGREEN = { r: 124, g: 252, b: 0 }.freeze
  LEMONCHIFFON = { r: 255, g: 250, b: 205 }.freeze
  LIGHTBLUE = { r: 173, g: 216, b: 230 }.freeze
  LIGHTCORAL = { r: 240, g: 128, b: 128 }.freeze
  LIGHTCYAN = { r: 224, g: 255, b: 255 }.freeze
  LIGHTGOLDENRODYELLOW = { r: 250, g: 250, b: 210 }.freeze
  LIGHTGRAY = { r: 211, g: 211, b: 211 }.freeze
  LIGHTGREEN = { r: 144, g: 238, b: 144 }.freeze
  LIGHTGREY = { r: 211, g: 211, b: 211 }.freeze
  LIGHTPINK = { r: 255, g: 182, b: 193}.freeze
  LIGHTSALMON = { r: 255, g: 160, b: 122 }.freeze
  LIGHTSEAGREEN = { r: 32, g: 178, b: 170 }.freeze
  LIGHTSKYBLUE = { r: 135, g: 206, b: 250 }.freeze
  LIGHTSLATEGRAY = { r: 119, g: 136, b: 153 }.freeze
  LIGHTSLATEGREY = { r: 119, g: 136, b: 153 }.freeze
  LIGHTSTEELBLUE = { r: 176, g: 196, b: 222 }.freeze
  LIGHTYELLOW = { r: 255, g: 255, b: 224 }.freeze
  LIME = { r: 0, g: 255, b: 0 }.freeze
  LIMEGREEN = { r: 50, g: 205, b: 50 }.freeze
  LINEN = { r: 250, g: 240, b: 230 }.freeze
  MAGENTA = { r: 255, g: 0, b: 255 }.freeze
  MAROON = { r: 128, g: 0, b: 0 }.freeze
  MEDIUMAQUAMARINE = { r: 102, g: 205, b: 170 }.freeze
  MEDIUMBLUE = { r: 0, g: 0, b: 205 }.freeze
  MEDIUMORCHID = { r: 186, g: 85, b: 211 }.freeze
  MEDIUMPURPLE = { r: 147, g: 112, b: 219 }.freeze
  MEDIUMSEAGREEN = { r: 60, g: 179, b: 113 }.freeze
  MEDIUMSLATEBLUE = { r: 123, g: 104, b: 238 }.freeze
  MEDIUMSPRINGGREEN = { r: 0, g: 250, b: 154 }.freeze
  MEDIUMTURQUOISE = { r: 72, g: 209, b: 204 }.freeze
  MEDIUMVIOLETRED = { r: 199, g: 21, b: 133 }.freeze
  MIDNIGHTBLUE = { r: 25, g: 25, b: 112 }.freeze
  MINTCREAM = { r: 245, g: 255, b: 250 }.freeze
  MISTYROSE = { r: 255, g: 228, b: 225 }.freeze
  MOCCASIN = { r: 255, g: 228, b: 181 }.freeze
  NAVAJOWHITE = { r: 255, g: 222, b: 173 }.freeze
  NAVY = { r: 0, g: 0, b: 128 }.freeze
  OLDLACE = { r: 253, g: 245, b: 230 }.freeze
  OLIVE = { r: 128, g: 128, b: 0 }.freeze
  OLIVEDRAB = { r: 107, g: 142, b: 35 }.freeze
  ORANGE = { r: 255, g: 165, b: 0 }.freeze
  ORANGERED = { r: 255, g: 69, b: 0 }.freeze
  ORCHID = { r: 218, g: 112, b: 214 }.freeze
  PALEGOLDENROD = { r: 238, g: 232, b: 170 }.freeze
  PALEGREEN = { r: 152, g: 251, b: 152 }.freeze
  PALETURQUOISE = { r: 175, g: 238, b: 238 }.freeze
  PALEVIOLETRED = { r: 219, g: 112, b: 147 }.freeze
  PAPAYAWHIP = { r: 255, g: 239, b: 213 }.freeze
  PEACHPUFF = { r: 255, g: 218, b: 185 }.freeze
  PERU = { r: 205, g: 133, b: 63 }.freeze
  PINK = { r: 255, g: 192, b: 203 }.freeze
  PLUM = { r: 221, g: 160, b: 221 }.freeze
  POWDERBLUE = { r: 176, g: 224, b: 230 }.freeze
  PURPLE = { r: 128, g: 0, b: 128 }.freeze
  PURPLE2 = { r: 127, g: 0, b: 127 }.freeze
  PURPLE3 = { r: 160, g:  32, b: 240 }.freeze
  REBECCAPURPLE = { r: 102, g: 51, b: 153 }.freeze
  RED = { r: 255, g: 0, b: 0 }.freeze
  ROSYBROWN = { r: 188, g: 143, b: 143 }.freeze
  ROYALBLUE = { r: 65, g: 105, b: 225 }.freeze
  SADDLEBROWN = { r: 139, g: 69, b: 19 }.freeze
  SALMON = { r: 250, g: 128, b: 114 }.freeze
  SANDYBROWN = { r: 244, g: 164, b: 96 }.freeze
  SEAGREEN = { r: 46, g: 139, b: 87 }.freeze
  SEASHELL = { r: 255, g: 245, b: 238 }.freeze
  SIENNA = { r: 160, g: 82, b: 45 }.freeze
  SILVER = { r: 192, g: 192, b: 192}.freeze
  SKYBLUE = { r: 135, g: 206, b: 235 }.freeze
  SLATEBLUE = { r: 106, g: 90, b: 205 }.freeze
  SLATEGRAY = { r: 112, g: 128, b: 144 }.freeze
  SLATEGREY = { r: 112, g: 128, b: 144 }.freeze
  SNOW = { r: 255, g: 250, b: 250 }.freeze
  SPRINGGREEN = { r: 0, g: 255, b: 127 }.freeze
  STEELBLUE = { r: 70, g: 130, b: 180 }.freeze
  TAN = { r: 210, g: 180, b: 140 }.freeze
  TEAL = { r: 0, g: 128, b: 128 }.freeze
  THISTLE = { r: 216, g: 191, b: 216 }.freeze
  TOMATO = { r: 255, g: 99, b: 71 }.freeze
  TURQUOISE = { r: 64, g: 224, b: 208 }.freeze
  VIOLET = { r: 238, g: 130, b: 238 }.freeze
  WHEAT = { r: 245, g: 222, b: 179 }.freeze
  WHITE = { r: 255, g: 255, b: 255 }.freeze
  WHITESMOKE = { r: 245, g: 245, b: 245 }.freeze
  YELLOW = { r: 255, g: 255, b: 0 }.freeze
  YELLOWGREEN = { r: 154, g: 205, b: 50 }.freeze

  # Nokia Jam
  NOKIALIGHT = { r: 199, g: 240, b: 216 }.freeze
  NOKIADARK = { r: 67, g: 82, b: 61 }.freeze
  NOKIAHARSHLIGHT = { r: 155, g: 199, b: 0 }.freeze
  NOKIAHARSHDARK  = { r: 43, g:  63, b: 9 }.freeze
  NOKIAGRAYLIGHT = { r: 135, g: 145, b: 136 }.freeze
  NOKIAGREYLIGHT = { r: 135, g: 145, b: 136 }.freeze
  NOKIAGRAYDARK = { r: 26, g: 25, b: 20 }.freeze
  NOKIAGREYDARK = { r: 26, g: 25, b: 20 }.freeze

  # Dragonruby
  DRAGONRED = { r: 227, g: 19, b: 0 }.freeze
  DRAGONGRAY = { r: 223, g: 223, b: 223 }.freeze
  DRAGONGREY = { r: 223, g: 223, b: 223 }.freeze

  class << self
    def from_rgb_hex hex
      { r: (hex & 0xFF0000) >> 16, g: (hex & 0x00FF00) >> 8, b: hex & 0x0000FF }
    end

    def to_rgb_hex rgb
      0x000000 | (rgb[:r] << 16) + (rgb[:g] << 8) + rgb[:b]
    end

    def from_rgba_hex hex
      { r: (hex & 0xFF000000) >> 24, g: (hex & 0x00FF0000) >> 16, b: (hex & 0x0000FF00) >> 8, a: hex & 0x000000FF }
    end

    def to_rgba_hex rgba
      0x00000000 | (rgba[:r] << 24) + (rgba[:g] << 16) + (rgba[:b] << 8) + (rgba[:a] || 255)
    end

    def from_bgr_hex hex
      { r: hex & 0x0000FF, g: (hex & 0x00FF00) >> 8, b: (hex & 0xFF0000) >> 16 }
    end

    def to_bgr_hex bgr
      0x000000 | (bgr[:b] << 16) + (bgr[:g] << 8) + bgr[:r]
    end

    def from_abgr_hex hex
      { r: hex & 0x000000FF, g: (hex & 0x0000FF00) >> 8, b: (hex & 0x00FF0000) >> 16, a: (hex & 0xFF000000) >> 24 }
    end

    def to_abgr_hex abgr
      0x00000000 |  ((abgr[:a] || 255) << 24) + (abgr[:b] << 16) + (abgr[:g] << 8) + abgr[:r]
    end

    def rgb_to_lch rgb
      # To XYZ
      r = (rgb[:r] * 0.00392156862745098).abs
      g = (rgb[:g] * 0.00392156862745098).abs
      b = (rgb[:b] * 0.00392156862745098).abs
      r = r > 0.04045 ? ((r + 0.055) * 0.9478672985781991)**2.4 : r * 0.07739938080495357
      g = g > 0.04045 ? ((g + 0.055) * 0.9478672985781991)**2.4 : g * 0.07739938080495357
      b = b > 0.04045 ? ((b + 0.055) * 0.9478672985781991)**2.4 : b * 0.07739938080495357
      r *= r <=> 0
      g *= g <=> 0
      b *= b <=> 0

      x = r * 0.4124564 + g * 0.3575761 + b * 0.1804375
      y = r * 0.2126729 + g * 0.7151522 + b * 0.0721750
      z = r * 0.0193339 + g * 0.1191920 + b * 0.9503041

      # To LAB
      x *= 1.0521110608435826
      z *= 0.9184170164304805
      fx = x > 0.008856 ? x**0.3333333333333333 : 7.787036 * x + 0.1379310
      fy = y > 0.008856 ? y**0.3333333333333333 : 7.787036 * y + 0.1379310
      fz = z > 0.008856 ? z**0.3333333333333333 : 7.787036 * z + 0.1379310
      l = 116.0 * fy - 16
      a = 500.0 * (fx - fy)
      b = 200.0 * (fy - fz)

      # To LCH
      angle = Math.atan2(b, a) * 57.29577951308232

      { l: l, c: Math.sqrt(a * a + b * b), h: angle.negative? ? angle + 360.0 : angle }
    end

    def lch_to_rgb lch
      # To LAB
      c = lch[:c]
      rad = lch[:h] * 0.017453292519943295
      a = Math.cos(rad) * c
      b = Math.sin(rad) * c

      # To XYZ
      y = (lch[:l] + 16.0) * 0.008620689655172414
      x = y + a * 0.002
      z = y - b * 0.005

      y3 = y * y * y
      x3 = x * x * x
      z3 = z * z * z
      y = y3 > 0.008856 ? y3 : (y - 0.1379310) * 0.12841856644813252
      x = (x3 > 0.008856 ? x3 : (x - 0.1379310) * 0.12841856644813252) * 0.95047
      z = (z3 > 0.008856 ? z3 : (z - 0.1379310) * 0.12841856644813252) * 1.088_83

      # To RGB
      r = (x * 3.2404542 + y * -1.5371385 + z * -0.498_531_4).abs
      g = (x * -0.9692660 + y * 1.8760108 + z * 0.041_556_0).abs
      b = (x * 0.0556434 + y * -0.2040259 + z * 1.057_225_2).abs

      r = r > 0.0031308 ? 1.055 * r**0.4166666666666667 - 0.055 : r * 12.92
      g = g > 0.0031308 ? 1.055 * g**0.4166666666666667 - 0.055 : g * 12.92
      b = b > 0.0031308 ? 1.055 * b**0.4166666666666667 - 0.055 : b * 12.92

      { r: (r * 255.0).round, g: (g * 255.0).round, b: (b * 255.0).round }
    end

    def lerp_lch a, b, t
      angle = (((((b[:h] - a[:h]) % 360.0) + 540.0) % 360.0) - 180.0) * t
      { l: a[:l] + (b[:l] - a[:l]) * t, c: a[:c] + (b[:c] - a[:c]) * t, h: (a[:h] + angle + 360.0) % 360.0 }
    end

    def lerp_rgb a, b, t
      { r: a[:r] + (b[:r] - a[:r]) * t, g: a[:g] + (b[:g] - a[:g]) * t, b: a[:b] + (b[:b] - a[:b]) * t }
    end
  end
end
